<?php
session_start();
include("config.php");

$_SESSION['errorimport'] = "";

if(!isset($_SESSION['id'])){
	header('location: login.php');
}
else{
	if(!preg_match("#Confirmation#",$_SESSION['roles']) AND ($_SESSION['type'] == "moderator")){	
		header('location: 404.php');
	}
}

if(isset($_SESSION['id']) AND isset($_SESSION['fullname'])){
?>
<!DOCTYPE html>
<html lang="zxx">
	<head>
		<meta charset="utf-8">
		<title><?php echo $settings['appname'];?> - CPanel</title>
		<meta name="description" content="<?php echo $settings['appname'];?> - CPanel">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="robots" content="noindex,nofollow" />
		<!-- General CSS Settings -->
		<link rel="stylesheet" href="css/general_style.css">
		<!-- Main Style of the template -->
		<link rel="stylesheet" href="css/main_style.php">
		<!-- Landing Page Style -->
		<link rel="stylesheet" href="css/reset_style.css">
		<!-- Awesomefont -->
		<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.4.1/css/all.css" integrity="sha384-5sAR7xN1Nv6T6+dT2mhtzEpVJvfS3NScPQTrOxhwjIuvcA67KV2R5Jz6kr4abQsz" crossorigin="anonymous">
		<!-- QRCode Scanner -->
		<link rel="stylesheet" type="text/css" href="css/qrcode-reader.css" />
		<!-- DateRangePicker -->
		<link rel="stylesheet" type="text/css" href="css/daterangepicker.css" />
		<!-- Fav Icon -->
		<link rel="shortcut icon" href="../favicon.ico">
		<?php include("onesignal.php");?>
	</head>
	<body>

		<!-- Wrapper -->
		<div class="lx-wrapper">
			<!-- Header -->
			<div class="lx-header">
				<?php include('header.php');?>
			</div>
			<!-- Main -->
			<div class="lx-main">
				<div class="lx-main-leftside">
					<?php include('mainmenu.php');?>
				</div>
				<!-- Main Content -->
				<div class="lx-main-content">
					<div class="lx-page-header">
						<h2>Confirmation
							<?php
							if($_SESSION['type'] != "client" AND $_SESSION['type'] != "affiliate"){
								$extrareq = $userwhere;
								if($_SESSION['type'] == "dlm" AND $_SESSION['roles'] == "Affichage commun"){
									$extrareq = " AND (dlm='".$_SESSION['id']."' OR city IN(SELECT city FROM shippingfees WHERE dlm='".$_SESSION['id']."' AND trash='1'))";
								}
								$back = $bdd->query("SELECT id FROM commands WHERE state='Reported' AND phase='confirmation' AND (datereported BETWEEN '".(strtotime(date("d-m-Y"))-3600)."' AND '".(strtotime(date("d-m-Y"))+(60*60*24)-1)."') AND trash='1'".$extrareq);
								if($back->rowCount() > 0){
									?>
							<a href="javascript:;" class="lx-reported-blink blink" data-state="Reported" data-datereport="<?php echo date("d/m/Y")." - ".date("d/m/Y");?>"><?php echo $back->rowCount();?> reported</a>
									<?php
								}
							}
							?>
						</h2>
					</div>
					<?php
					$back = $bdd->query("SELECT fullname,dateactive FROM users WHERE (type='worker' OR type='moderator') AND trash='1'");
					if($_SESSION['type'] == "moderator" AND $back->rowCount() > 0){
					?>
					<div class="lx-g1">
						<div class="lx-stats-bloc">
							<ul class="lx-workers-state">
								<?php
								while($row = $back->fetch()){
									$class = " lx-connected";
									if($row['dateactive'] != ""){
										if($row['dateactive'] < (time() - (60*20))){
											$class = " lx-disconnected";
										}
										elseif($row['dateactive'] < (time() - (60*10))){
											$class = " lx-halfconnected";
										}
									}
									else{
										$class = " lx-disconnected";
									}
									?>
								<li><i class="fa fa-circle<?php echo $class;?>"></i> <?php echo $row['fullname'];?></li>
									<?php
								}
								?>
							</ul>
						</div>
					</div>
					<?php
					}					
					?>
					<div class="lx-clear-fix"></div>
					<div class="lx-page-content">
						<div class="lx-g1">
							<div class="lx-keyword">
								<label><a href="javascript:;" class="lx-search-keyword"><i class="fa fa-search"></i></a><input type="text" name="keyword" id="keyword" placeholder="Keyword" data-table="commands" /></label>
								<label style="<?php if($_SESSION['type'] != "moderator" OR $myclients != ""){echo "display:none;";}?>">
									<select name="manager" id="manager">
										<option value="">All managers</option>
										<?php
										$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='moderator' AND roles LIKE '%Responsable%' AND trash='1' ORDER BY fullname");
										while($row = $back->fetch()){
											?>
										<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
											<?php 
										}
										?>
									</select>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="worker" id="workers" placeholder="All workers" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='worker' AND trash='1' ORDER BY fullname");
											if($_SESSION['type']=="worker"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type='worker' AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['fullname'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable#",$_SESSION['roles'])){echo "display:none;";}?>">
									<select name="type" id="type">
										<option value="">All accounts</option>
										<option value="client" <?php echo preg_match("#Responsable seller#",$_SESSION['roles'])?"selected":"";?>>Clients Seller</option>
										<option value="affiliate" <?php echo preg_match("#Responsable affiliate#",$_SESSION['roles'])?"selected":"";?>>Clients Affiliate</option>
									</select>
								</label>								
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable affiliate#",$_SESSION['roles'])){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="client" id="clients" placeholder="All clients seller" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND trash='1'".$myclientsids." ORDER BY fullname");
											if($_SESSION['type']=="client"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable seller#",$_SESSION['roles'])){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="clientaff" id="clientsaff" placeholder="All clients affiliate" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
											if($_SESSION['type']=="client"){
												$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['fullname']!=""?$row['fullname']:$row['store'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['store']." (".$row['fullname'].")";?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="store" id="stores" placeholder="All stores" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT * FROM stores WHERE trash='1'");		
											if($_SESSION['type'] == "client"){
												$back = $bdd->query("SELECT * FROM stores WHERE trash='1'".$userwhere);		
											}
											if($_SESSION['type'] == "worker"){
												$back = $bdd->query("SELECT * FROM stores WHERE trash='1' AND title IN('".str_replace(",","','",$_SESSION['clientslist'])."')");		
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['title'];?>" data-ids="<?php echo $row['title'];?>" /> <?php echo $row['title'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="city" id="cities" placeholder="All cities" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT DISTINCT city FROM shippingfees WHERE trash='1' ORDER BY city");
											if($_SESSION['type'] == "dlm"){
												$back = $bdd->query("SELECT DISTINCT city FROM shippingfees WHERE trash='1' AND dlm='".$_SESSION['id']."' ORDER BY city");
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['city'];?>" data-ids="<?php echo $row['city'];?>" /> <?php echo $row['city'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select" style="<?php if($_SESSION['type'] == "dlm"){echo "display:none;";}?>">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="product" id="product" placeholder="All products" data-ids="" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT id,title FROM stocks WHERE trash='1' ORDER BY id");
											if($_SESSION['type'] == "client"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE client='".$_SESSION['id']."' AND trash='1' ORDER BY id");
											}
											if($_SESSION['type'] == "dlm"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE 1=2");
											}
											if($_SESSION['type'] == "affiliate"){
												$back = $bdd->query("SELECT id,title FROM stocks WHERE (client='0' OR affiliate='on') AND trash='1' ORDER BY id");
											}
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['title'];?>" data-ids="<?php echo $row['id'];?>" /> <?php echo $row['title'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label class="lx-advanced-select">
									<i class="fa fa-caret-down"></i>
									<input type="text" name="state" id="states" value="<?php if(isset($_GET['s'])){if($_GET['s'] != ""){echo $_GET['s'];}}?>" placeholder="All status" readonly />
									<div>
										<a href="javascript:;" class="lx-state-empty">Empty</a>
										<a href="javascript:;" class="lx-state-filter">Filter</a>
										<div class="lx-clear-fix"></div>
										<input type="text" name="searchadvanced" style="margin-bottom:20px;" />
										<ul>
											<?php
											$back = $bdd->query("SELECT state FROM trackingstates WHERE trash='1' AND phase LIKE '%Confirmation%' ORDER BY state");
											while($row = $back->fetch()){
												?>
											<li><label><input type="checkbox" value="<?php echo $row['state'];?>" <?php if(isset($_GET['s'])){if(preg_match("#".str_replace(",","|",$_GET['s'])."#",$row['state'])){echo "checked";}}?> /> <?php echo $row['state'];?><del class="checkmark"></del></label></li>
												<?php
											}
											?>
										</ul>
									</div>
								</label>
								<label style="<?php if($_SESSION['type'] != "moderator" OR preg_match("#Responsable#",$_SESSION['roles'])){echo "display:none;";}?>">
									<select name="upsell" id="upsell">
										<option value="">Upsell</option>
										<option value="yes">Upsell: Yes</option>
										<option value="no">Upsell: No</option>
									</select>
								</label>	
								<label><input type="text" name="nbcalls" id="nbcalls" data-table="commands" placeholder="Number of calls" /></label>
								<label><input type="text" name="dateadd" id="dateadd" data-table="commands" value="<?php echo date("d/m/Y",time()-2592000)." - ".date("d/m/Y");?>" placeholder="Date add" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestart" id="datestart" value="<?php echo date("d/m/Y",time()-2592000);?>" />
								<input type="hidden" name="dateend" id="dateend" value="<?php echo date("d/m/Y");?>" />
								<label><input type="text" name="dateupdate" id="dateupdate" data-table="commands" placeholder="Date update" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestartupdate" id="datestartupdate" />
								<input type="hidden" name="dateendupdate" id="dateendupdate" />
								<label><input type="text" name="datereport" id="datereport" data-table="commands" placeholder="Date reported" readonly style="background:white;cursor:pointer;" /></label>
								<input type="hidden" name="datestartreport" id="datestartreport" />
								<input type="hidden" name="dateendreport" id="dateendreport" />
								<input type="hidden" name="sortby" value="" />
								<input type="hidden" name="orderby" value="DESC" />
							</div>
							<div class="lx-add-form">
								<a href="javascript:;" class="lx-new lx-new-command lx-open-popup" data-title="command">+ New</a>
								<?php
								if($_SESSION['type'] != "worker"){
									?>
								<a href="javascript:;" class="lx-new lx-export-commands"><i class="fa fa-download"></i> Export</a>
								<a href="javascript:;" class="lx-new lx-open-popup" data-title="importer"><i class="fa fa-upload"></i> Import</a>
									<?php
									if($_SESSION['type'] == "affiliate"){
									?>
								<a href="ExampleImportationAffiliate.xlsx" class="lx-new">Example</a>
									<?php
									}
									else{
									?>
								<a href="ExampleImportationColis.xlsx" class="lx-new">Example</a>
									<?php										
									}
									?>
								<a href="errorimport.php" class="lx-new lx-error-import" style="display:none;">Orders Not imported</a>
									<?php
								}
								else{
								?>
								<a href="javascript:;" class="lx-new lx-grab-confirmation">+ Grab</a>
								<?php									
								}
								if($_SESSION['type'] == "moderator"){
									?>
								<a href="javascript:;" class="lx-new lx-assign-command lx-open-popup" data-title="assign">Assign</a>
								<a href="javascript:;" class="lx-new qrcode-reader" id="openreader-single" data-qrr-target="#qrcode" data-qrr-audio-feedback="true">Scan QRCode</a>
								<input type="hidden" id="qrcode" />
									<?php
								}
								?>
							</div>
							<div class="lx-quick-filter">
								<?php 
								$req = $myclients;
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state='New' AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="New" style="background:#828282;">New (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state='Confirmed' AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Confirmed" style="background:#7EC855;">Confirmed (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state='Reported' AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Reported" style="background:#39add1;">Reported (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND (state LIKE '%Not answering%' OR state LIKE '%Unreachable%') AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" style="background:#FF7700;" data-states="Not answering,Not answering 2 fois,Not answering 3 fois,Not answering 4 fois,Not answering 5 fois,Unreachable">Not answering (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								$back = $bdd->query("SELECT id FROM commands WHERE phase='confirmation' AND state IN('Canceled') AND trash='1'".$userwhere.$req);
								if($back->rowCount() > 0){
									?>
								<a href="javascript:;" data-states="Canceled" style="background:#CC0000;">Canceled (<?php echo $back->rowCount();?>)</a>
									<?php
								}
								?>
							</div>
							<div class="lx-table lx-table-commands">

							</div>
							<?php
							if($_SESSION['type'] == "moderator"){
							?>
							<div class="lx-action-bulk">
								<label><span>Action: </span>
									<select name="statebulk">
										<option value="">Select action</option>
										<option value="delete">Delete to trash</option>
										<option value="deletepermenantly">Delete definitely</option>
										<option value="restore">Restore</option>
										<option value="collect">Collect</option>
										<?php
										$back = $bdd->query("SELECT state FROM trackingstates WHERE phase='Confirmation' AND trash='1' ORDER BY state");
										while($row = $back->fetch()){
											?>
										<option value="<?php echo $row['state'];?>"><?php echo $row['state'];?></option>
											<?php 
										}
										?>
									</select>
								</label>
								<a href="javascript:;">Apply</a>
							</div>
							<?php
							}
							$nb = 20;
							if($parametres['nbrows'] != "" AND $parametres['nbrows'] != "0"){
								$nb = $parametres['nbrows'];
							}						
							?>
							<div class="lx-action-bulk">
								<label><span>Show: </span>
									<select name="nbrows">
										<option value="20" <?php if($nb==20){echo "selected";}?>>20</option>
										<option value="50" <?php if($nb==50){echo "selected";}?>>50</option>
										<option value="100" <?php if($nb==100){echo "selected";}?>>100</option>
										<option value="250" <?php if($nb==250){echo "selected";}?>>250</option>
										<option value="500" <?php if($nb==500){echo "selected";}?>>500</option>
										<option value="1000" <?php if($nb==500){echo "selected";}?>>1000</option>
									</select>
								</label><span>Lines per page</span>
							</div>
							<?php
							$back = $bdd->query("SELECT COUNT(*) AS nb FROM commands WHERE trash='1' AND phase='confirmation'".$userwhere);
							$row = $back->fetch();
							?>
							<div class="lx-pagination" style="<?php if($row['nb'] <= $nb){echo "display:none;";}?>">
								<?php
								$nbpages = ceil($row['nb']/$nb);
								?>
								<ul data-table="confirmation" data-state="1" data-start="0" data-nbpage="<?php echo $nb;?>" data-posts="<?php echo $row['nb'];?>">
									<li><span>Page <ins>1</ins> of <abbr><?php echo $nbpages;?></abbr></span></li>
									<li><a href="javascript:;" class="previous disabled"><i class="fa fa-angle-left"></i></a></li>
									<li>
										<select id="pgbumber">
											<?php
											for($i=1;$i<=$nbpages;$i++){
												?>
											<option value="<?php echo ($i-1);?>"><?php echo $i;?></option>
												<?php
											}
											?>
										</select>
									</li>
									<li><a href="javascript:;" class="next <?php if($nbpages == 1){echo 'disabled';}?>"><i class="fa fa-angle-right"></i></a></li>
								</ul>
								<div class="lx-clear-fix"></div>
							</div>
							<div class="lx-clear-fix"></div>
						</div>
						<div class="lx-clear-fix"></div>
					</div>
					<div class="lx-clear-fix"></div>
				</div>
				<div class="lx-clear-fix"></div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup command confirmation">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Update order</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="commandsform">
										<div class="lx-textfield lx-g1 lx-pb-0" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
											<label><span>Client:</span>
												<select name="client" data-isnotempty="" data-message="Select a client!!">
													<option value="">Select a client</option>
													<?php
													$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
													if($_SESSION['type'] == "client"){
														$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
													}
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>" <?php if($row['id'] == $_SESSION['id']){echo "selected";}?>><?php echo $row['store']." (".$row['fullname'].")";?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Store:</span>
												<select name="stores" data-isnotempty="" data-message="Select a store!!">
													<option value="">Select a store</option>
													<?php
													$back = $bdd->query("SELECT * FROM stores WHERE trash='1'");		
													if($_SESSION['type'] == "client"){
														$back = $bdd->query("SELECT * FROM stores WHERE trash='1'".$userwhere);		
													}
													if($_SESSION['type'] == "worker"){
														$back = $bdd->query("SELECT * FROM stores WHERE trash='1' AND title IN('".str_replace(",","','",$_SESSION['clientslist'])."')");		
													}
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['title'];?>" data-client="<?php echo $row['client']?>"><?php echo $row['title'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div style="<?php if($settings['reseller'] == "0"){echo "display:none;";}?>">
											<div class="lx-textfield lx-g2 lx-pb-0">
												<label><span>Seller name: </span><input type="text" name="clientname" /></label>
											</div>
											<div class="lx-textfield lx-g2 lx-pb-0">
												<label><span>Seller Phone: </span><input type="text" name="clientphone" /></label>
											</div>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g3 lx-pb-0" style="display:none;">
											<label><span>Code: </span><input type="text" name="code" /></label>
										</div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>Customer: </span><input type="text" name="fullname" data-isnotempty="" data-message="Enter a customer!!" /></label>
										</div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>Phone: </span><input type="text" name="phone" data-isphone="" data-message="Ex: 06xxxxxxxx, 07xxxxxxxx ..." /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0" style="display:none;">
											<label><span>Delivery man:</span>
												<select name="dlm" data-isnotempty="" data-message="Select a delivery men!!">
													<option value="0">Select a delivery men</option>
													<?php
													$back = $bdd->query("SELECT id,fullname FROM users WHERE type='dlm' AND trash='1' ORDER BY fullname");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>City:</span>
												<select name="city" class="todropdown" data-isnotempty="" data-message="Select a city!!">
													<option value="">Select a city</option>
													<?php
													$back = $bdd->query("SELECT DISTINCT city FROM shippingfees ORDER BY city");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['city'];?>"><?php echo $row['city'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g2 lx-pb-0">
											<label><span>District:</span>
												<select name="sector" class="todropdown" data-isnotempty="" data-message="Select a district!!">
													<option value="">Select a district</option>
													<?php
													$back = $bdd->query("SELECT DISTINCT sector,city FROM sectors ORDER BY sector");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['sector'];?>" data-city="<?php echo $row['city'];?>"><?php echo $row['sector'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Address: </span><input type="text" name="address" data-isnotempty="" data-message="Saisissez une adresse!!" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="fromstock">
											<?php
											$back = $bdd->query("SELECT id,title,qty,price FROM stocks WHERE trash='1' ORDER BY id");
											if($_SESSION['type'] == "client"){
												if($_SESSION['roles'] == "Products Seller"){
													$back = $bdd->query("SELECT id,title,qty,price FROM stocks WHERE (client='".$_SESSION['id']."' OR seller='on') AND trash='1' ORDER BY id");
												}
												else{
													$back = $bdd->query("SELECT id,title,qty,price FROM stocks WHERE client='".$_SESSION['id']."' AND trash='1' ORDER BY id");
												}
											}	
											if($_SESSION['type'] == "affiliate"){
												$back = $bdd->query("SELECT id,title,price FROM stocks WHERE (client='0' OR affiliate='on') AND trash='1' ORDER BY id");
											}
											?>
											<div>
												<div class="lx-textfield lx-g<?php echo $_SESSION['type']=="affiliate"?"1":"2";?> lx-pb-0">
													<label><span>Product:</span>
														<select name="product" data-isnumber="" data-message="Select a product">
															<option value="">Select a product</option>
															<?php
															while($row = $back->fetch()){
																?>
															<option value="<?php echo $row['id'];?>" data-price="<?php echo $row['price'];?>"><?php echo $row['title'];?></option>
																<?php
															}
															?>
														</select>
													</label>
												</div>
												<div class="lx-textfield lx-g2 lx-pb-0" style="<?php echo $_SESSION['type']=="affiliate"?"display:none;":"";?>">
													<label><span>Quantity: </span><input type="text" name="qty" /></label>
												</div>
												<div class="lx-clear-fix"></div>
											</div>
											<?php
											if($_SESSION['type']!="affiliate"){
											?>
											<a href="javascript:;" class="lx-add-other-stock">Add another product</a>
											<?php
											}
											?>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Price: </span><input type="text" name="price" data-isnumber="" data-message="Enter a price" /></label>
										</div>	
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Note: </span><textarea name="note" /></textarea></label>
										</div>			
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><input type="checkbox" name="change" value="0" /> Express<del class="checkmark"></del></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><input type="checkbox" name="openpackage" value="1" /> Econom<del class="checkmark"></del></label>
										</div>												
										<div class="lx-clear-fix"></div>							
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="idclient" value="<?php echo $_SESSION['type']=="client"?$_SESSION['id']:"47";?>" />
											<input type="hidden" name="idticket" id="idticket" />
											<input type="hidden" name="phase" value="confirmation" />
											<input type="hidden" name="state" value="New" />
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Save</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup editstate">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Edit status</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="editstateform">
										<div class="lx-textfield lx-g1 lx-pb-0">
											<?php
											$agent = "Moderator";
											if($_SESSION['type'] == "dlm"){
												$agent = "Delivery man";
											}
											if($_SESSION['type'] == "client"){
												$agent = "Client";
											}
											$back = $bdd->query("SELECT state,color FROM trackingstates WHERE agent LIKE '%".$agent."%' AND phase LIKE '%Confirmation%' AND trash='1' ORDER BY state");	
											while($row = $back->fetch()){
												?>
											<a href="javascript:;" class="lx-coli-state-delivarymen" data-state="<?php echo $row['state'];?>" style="font-weight:500;background:<?php echo $row['color'];?>;color:#FFFFFF;"><?php echo $row['state'];?></a>
												<?php
											}
											?>
											<input type="hidden" name="state" data-required="yes" /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0 datereported" style="display:none;">
											<label><span>Date reported: </span><input type="text" name="datereported" /></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0 reason" style="display:none;">
											<label><span>Reason: </span>
												<select name="reason">
													<option value="">Select a reason / Выберите причину / Sababni tanlang</option>
													<option value="customer_declined">Customer declined / Клиент отказался / Mijoz rad etdi</option>
													<option value="customer_unreachable">Customer unreachable / Клиент не отвечает / Mijoz javob bermayapti</option>
													<option value="wrong_details">Incorrect details / Неверные данные / Noto‘g‘ri ma’lumotlar</option>
													<option value="changed_mind">Customer changed mind / Клиент передумал / Mijoz fikrini o'zgartirdi</option>
													<option value="duplicate_order">Duplicate order / Дублированный заказ / Takroriy buyurtma</option>
													<option value="price_issue">Price too high / Цена не устроила / Narx mos kelmadi</option>
													<option value="delivery_too_long">Delivery takes too long / Долгая доставка / Yetkazib berish muddati uzoq</option>
													<option value="payment_issue">Payment issue / Проблемы с оплатой / To‘lov muammosi</option>
													<option value="other">Other reason / Другая причина / Boshqa sabab</option>
												</select>											
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Comment: </span><textarea name="comment" /></textarea></label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Save</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup importer">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Import orders</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="importform" enctype="multipart/form-data">
										<div class="lx-textfield lx-g1 lx-pb-0" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
											<label><span>Format:</span>
												<select name="format" id="importformat" data-isnotempty="" data-message="Choisissez un format!!">
													<option value="Stockout" selected>Stockout</option>
													<option value="Sendit">Sendit</option>
												</select>
											</label>
										</div>
										<div class="lx-textfield lx-g1 lx-pb-0" style="<?php if($_SESSION['type'] != "moderator"){echo "display:none;";}?>">
											<label><span>Client:</span>
												<select name="client" id="importclient" data-isnotempty="" data-message="Select a client!!">
													<option value="">Select a client</option>
													<?php
													$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND trash='1'".$myclientsids." ORDER BY fullname");
													if($_SESSION['type'] == "client"){
														$back = $bdd->query("SELECT id,fullname,store FROM users WHERE type IN('client','affiliate') AND id='".$_SESSION['id']."' AND trash='1' ORDER BY fullname");		
													}
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>" <?php if($row['id'] == $_SESSION['id']){echo "selected";}?>><?php echo $row['store']." (".$row['fullname'].")";?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-textfield lx-g1 lx-pb-0">
											<div class="lx-importer">
												<input type="file" name="xlsfile" id="importcommands" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" />
												<span>Select a file (excel)</span>
											</div>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="phase" id="importphase" value="confirmation" />
											<input type="hidden" name="state" id="importstate" value="New" />
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Import</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup assign">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Assign orders</h3>
								</div>
								<div class="lx-add-form">
									<form action="#" method="post" id="assignform">
										<div class="lx-textfield lx-g1 lx-pb-0">
											<label><span>Employé:</span>
												<select name="worker" data-isnotempty="" data-message="Select a worker!!">
													<option value="0">Select a worker</option>
													<?php
													$back = $bdd->query("SELECT id,fullname FROM users WHERE type='worker' AND trash='1' ORDER BY fullname");
													while($row = $back->fetch()){
														?>
													<option value="<?php echo $row['id'];?>"><?php echo $row['fullname'];?></option>
														<?php 
													}
													?>
												</select>
											</label>
										</div>
										<div class="lx-clear-fix"></div>
										<div class="lx-submit lx-g1 lx-pb-0">
											<input type="hidden" name="id" value="0" />
											<a href="javascript:;">Save</a>
										</div>
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup phone">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Phone</h3>
								</div>
								<div class="lx-add-form">
									<div class="lx-phone-layouts">
										<a href="#">
											<img src="images/phone-icon.png" />
										</a>
										<a href="#">
											<img src="images/sms-icon.png" />
										</a>
										<a href="#" target="_blank">
											<img src="images/whatsapp-icon.png" />
										</a>
										<a href="#" target="_blank">
											<img src="images/telegram-icon.png" />
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->
			<div tabindex="0" class="lx-popup commandhistory">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Order history</h3>
								</div>
								<div class="lx-add-form">

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- End Popup -->	
			<div tabindex="0" class="lx-popup deleterecord">
				<div class="lx-popup-inside">
					<div class="lx-popup-content">
						<a href="javascript:;"><i class="material-icons">close</i></a>
						<div class="lx-popup-details">
							<div class="lx-form">
								<div class="lx-form-title">
									<h3>Deletion confirmation</h3>
								</div>
								<div class="lx-add-form">
									<div class="lx-delete-box">
										<p>Do you really want to delete this order?</p>
										<a href="javascript:;" class="lx-delete-record" data-action="deletecommand" data-id="">Yes</a>
										<a href="javascript:;" class="lx-cancel-delete">No</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- JQuery Script -->
		<script src="js/jquery-1.12.4.min.js"></script>
		<!-- Popup Script -->
		<script src="js/jquery.popup.js"></script>
		<!-- Calendar Script -->
		<script src="js/moment.min.js"></script>
		<script src="js/daterangepicker.js"></script>
		<!-- Main Script -->
		<script src="js/qrcode-reader.min.js"></script>
		<script src="js/script.js"></script>
		<script>
			$(document).ready(function(){
				loadConfirmation($(".lx-pagination ul").attr("data-state"));
				toDropDown();
			});
			$(function() {
				$(".qrcode-reader").qrCodeReader({
					callback: function(codes) {
						collectThis(codes);
					}
				});
				$('input[name="dateadd"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="dateadd"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestart"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateend"]').val(end.format('DD/MM/YYYY'));
						loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateadd"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestart"]').val('');
					$('input[name="dateend"]').val('');
					loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateupdate"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="dateupdate"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestartupdate"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateendupdate"]').val(end.format('DD/MM/YYYY'));
						loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="dateupdate"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestartupdate"]').val('');
					$('input[name="dateendupdate"]').val('');
					loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="datereport"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					ranges: {
						'Today': [moment(), moment()],
						'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
						'Last 7 Days': [moment().subtract(6, 'days'), moment()],
						'Last 30 Days': [moment().subtract(29, 'days'), moment()],
						'This Month': [moment().startOf('month'), moment().endOf('month')],
						'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
					},
					"linkedCalendars": false,
					"autoUpdateInput": false,
					"showCustomRangeLabel": false,
					"alwaysShowCalendars": true
					}, function(start, end, label) {
						$('input[name="datereport"]').val(start.format('DD/MM/YYYY') + " - " + end.format('DD/MM/YYYY'));
						$('input[name="datestartreport"]').val(start.format('DD/MM/YYYY'));
						$('input[name="dateendreport"]').val(end.format('DD/MM/YYYY'));
						loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="datereport"]').on('cancel.daterangepicker', function(ev, picker) {
					$(this).val('');
					$('input[name="datestartreport"]').val('');
					$('input[name="dateendreport"]').val('');
					loadConfirmation($(".lx-pagination ul").attr("data-state"));
				});
				$('input[name="datereported"]').daterangepicker({
					locale: {
					  format: 'DD/MM/YYYY'
					},
					singleDatePicker: true,
					showDropdowns: true
				});
			});
		</script>
	</body>
</html>
<?php
DB_Sanitize();
}
?>